
import ngsolve as ngs
from netgen.occ import (
    OCCGeometry, gp_Trsf, gp_Ax1, gp_Pnt,
    gp_Dir, IdentificationType
    )



angle = 120
move = (0, 0, 0)
# angle in degrees
trf_leftright = gp_Trsf().Rotation(gp_Ax1(gp_Pnt(0, 0, 0), gp_Dir(0, 0, 1)), angle)
trf2_interface = gp_Trsf().Translation(move)


geo_compound = OCCGeometry("periodicity.step", dim=2).shape
print("length edges left ", len(geo_compound.edges["left"]))
print("length edges right ", len(geo_compound.edges["right"]))


geo_compound.edges["per_outer"].Identify(
    geo_compound.edges["per_inner"], "interface", IdentificationType.PERIODIC, trf2_interface
)
geo_compound.edges["right"].Identify(
    geo_compound.edges["left"], "leftright", IdentificationType.PERIODIC, trf_leftright
)

geo = OCCGeometry(geo_compound, dim=2)
try:
    ngmesh = geo.GenerateMesh()
except Exception:
    input("Meshing failed - Check your geometry")
mesh = ngs.Mesh(ngmesh)

# set all outer and inner interface segments to same edgenr
bnames = mesh.GetBoundaries()
print("identifications : ", len(ngmesh.GetIdentifications()))

fes = ngs.H1(mesh=mesh, order=1, dirichlet='infini')
per_outer_gf = ngs.GridFunction(fes)
per_inner_gf = ngs.GridFunction(fes)
left_gf = ngs.GridFunction(fes)
right_gf = ngs.GridFunction(fes)

per_outer_gf.Set(ngs.CoefficientFunction((1)), definedon = mesh.Boundaries("per_outer"))
per_inner_gf.Set(ngs.CoefficientFunction((1)), definedon = mesh.Boundaries("per_inner"))

left_gf.Set(ngs.CoefficientFunction((1)), definedon = mesh.Boundaries("left"))
right_gf.Set(ngs.CoefficientFunction((1)), definedon = mesh.Boundaries("right"))

list_str = ["left", "right", "per_inner", "per_outer"]
list_gfs = [left_gf, right_gf, per_inner_gf, per_outer_gf]

for idx, gf in enumerate(list_gfs) :
    n_points = 0
    for k in range(len(mesh.ngmesh.Points())):
        if gf.vec.FV()[k] > 0.5:
            n_points += 1
    print("nbr points ", list_str[idx], n_points)
ngs.Draw(mesh)
